// Blog Detail Page (app/blogs/[slug]/page.jsx)
import { getAllBlogs, getBlogByTitle } from "@/service/BlogService";
import Image from "next/image";
import Link from "next/link";

export async function generateMetadata(props) {
  const { slug } = await props.params;
  const blog = await getBlogByTitle(slug);
  return {
    title: blog.metaTitle,
    description: blog.metaDescription,
    keywords: blog.keywords,
    alternates: { canonical: `/blogs/${slug}` },
    openGraph: {
      title: blog.metaTitle,
      description: blog.metaDescription,
      url: `/blogs/${slug}`,
      type: "article",
    },
  };
}

export default async function BlogDetailPage(props) {
  const { slug } = await props.params;
  const blog = await getBlogByTitle(slug);
  const allBlogs = await getAllBlogs(0, 5);
  const latestBlogs = allBlogs?.content || [];
  
  return (
    <section className="max-w-7xl mx-auto px-4 py-10">
      <div className="grid md:grid-cols-3 gap-10">
        {/* Main Blog Content */}
        <div className="md:col-span-2">
          <h1 className="text-3xl font-bold mb-4 text-foreground leading-tight">
            {blog.title}
          </h1>
          {blog.coverImageUrl && (
            <div className="relative w-full h-64 mb-6">
              <Image
                src={blog.coverImageUrl}
                alt={blog.title}
                priority
                fill
                className="object-cover rounded-md"
              />
            </div>
          )}
          <article className="blog-content">
            <div dangerouslySetInnerHTML={{ __html: blog.content }} />
          </article>

        </div>

        {/* Sidebar - Latest Blogs */}
        <aside className="space-y-4">
          <h2 className="text-xl font-semibold mb-2 text-foreground">Latest Blogs</h2>
          <ul className="space-y-2">
            {latestBlogs.map((b) => (
              <li key={b.id}>
                <Link
                  href={`/blogs/${b.formattedTitle}`}
                  className="block hover:underline text-sm text-muted-foreground"
                >
                  {b.title}
                </Link>
              </li>
            ))}
          </ul>
        </aside>
      </div>
    </section>
  );
}
